﻿//==============================================================================
//
// $File: //depot/indesign_6.0/gm/build/scripts/XHTML for Digital Editions/startup scripts/OEBExportMenuItemLoader.jsx $
//
// Owner: Paul Norton
//
// $Author: norton $
//
// $DateTime: 2008/09/03 13:49:38 $
//
// $Revision: #3 $
//
// $Change: 647347 $
//
// Copyright 2006 Adobe Systems Incorporated. All rights reserved.
//
// Purpose: Export InDesign documents to epub files or Digital Editions
//
// binary scripts cannot use the #targetengine directive.
// #targetengine is required so that the menu item will work (can't let the script unload.)
// so this script isn't binary, the rest of the plug-in will be.
//
//==============================================================================

#targetengine "digital editions"
var DEBUG = false;
var version = "2.0.0";
var build = "039";

function assert( condition, message )
{
		if (DEBUG && !condition) {alert("Assert: "+message);}
}

app.scriptArgs.set('de_version', version);
app.scriptArgs.set('de_build', build);

if(typeof(OEBExportMenuItem) == 'undefined') 
{
	//------------------------------------------------------------------------------
	// OEBExportMenuItemLoader.getScriptsFolderPath
	//------------------------------------------------------------------------------
	function OEBExportMenuItemLoader()
	{
	}
	//------------------------------------------------------------------------------
	// OEBExportMenuItemLoader.getScriptsFolderPath
	//------------------------------------------------------------------------------
	OEBExportMenuItemLoader.getScriptsFolderPath = function() 
	{
		try {
			var script = app.activeScript;
		} catch(e) {
			// we are running from the ESTK
			var script = File(e.fileName);
		}
		return script.parent.parent;
	} // DEExport.getScriptsFolderPath

	//------------------------------------------------------------------------------
	// OEBExportMenuItemLoader.loadScript
	//------------------------------------------------------------------------------
	OEBExportMenuItemLoader.loadScript = function(filename) 
	{
		return File(OEBExportMenuItemLoader.getScriptsFolderPath() + '/' + filename );
	} //OEBExportMenuItemLoader.loadScript

	OEBExportMenuItemLoader.script = OEBExportMenuItemLoader.loadScript("OEBExportMenuItem.jsxbin");
	if(!OEBExportMenuItemLoader.script.exists)
	{
		OEBExportMenuItemLoader.script = OEBExportMenuItemLoader.loadScript("OEBExportMenuItem.jsx");
	}
	// execute the script
	assert(OEBExportMenuItemLoader.script.exists, "Couldn't find OEBExportMenuItem.jsx* in " + OEBExportMenuItemLoader.getScriptsFolderPath());
	if(OEBExportMenuItemLoader.script.exists) 
	{
		var previousFolder = Folder.current;
		try
		{
			Folder.current = OEBExportMenuItemLoader.getScriptsFolderPath();
			app.doScript(OEBExportMenuItemLoader.script);
		}
		finally
		{
			Folder.changePath(previousFolder);
		}
	}
}